#pragma once

#include "../sdkIncludes.h"
#include "jabber_meeting_csdk.h"

	class IJMIMCallbackImpl : public IJMIMCallback
	{
	public:
		IJMIMCallbackImpl();
		~IJMIMCallbackImpl();

		void FuncInit(JMHandle libHandle);
		void FuncUnInit();

	public:	
		virtual void OnRecv_DSInvitation(wstring& strAccountName, wstring& strSessionName, wstring& strCmdMsg);

		virtual void OnRecv_DSDecline(wstring& strAccountName, wstring& strSessionName, wstring& strCmdMsg);

		virtual void OnRecv_DSCancelled(wstring& strAccountName, wstring& strSessionName, wstring& strCmdMsg);

		virtual void OnRecv_MeetingInvitation(wstring& strAccountName, wstring& strSessionName, wstring& strCmdMsg);

		virtual void OnRecv_MeetingDecline(wstring& strAccountName, wstring& strSessionName, wstring& strCmdMsg);

		virtual void OnRecv_MeetingCancelled(wstring& strAccountName, wstring& strSessionName, wstring& strCmdMsg);

		virtual void OnRecv_IMAlert(wstring& strAccountName, wstring& strSessionName, wstring& strCmdMsg);

	public:
		pf_jmsdk_IJMIMCallback_OnRecv_DSInvitation mpfOnRecv_DSInvitation;
		pf_jmsdk_IJMIMCallback_OnRecv_DSDecline mpfOnRecv_DSDecline;
		pf_jmsdk_IJMIMCallback_OnRecv_DSCancelled mpfOnRecv_DSCancelled;
		pf_jmsdk_IJMIMCallback_OnRecv_MeetingInvitation mpfOnRecv_MeetingInvitation;
		pf_jmsdk_IJMIMCallback_OnRecv_MeetingDecline mpfOnRecv_MeetingDecline;
		pf_jmsdk_IJMIMCallback_OnRecv_MeetingCancelled mpfOnRecv_MeetingCancelled;
		pf_jmsdk_IJMIMCallback_OnRecv_IMAlert mpfOnRecv_IMAlert;
	};

	class IJMCommonEventCallbackImpl : public IJMCommonEventCallback
	{
	public:
		IJMCommonEventCallbackImpl();
		~IJMCommonEventCallbackImpl();

		void FuncInit(JMHandle libHandle);
		void FuncUnInit();

	public:
		virtual void OnSignOn();

		virtual void OnSignOff();

		virtual void OnPreseceChange();

		virtual void OnUserSignOff(const wstring& strBuddyName);

		virtual void OnDSParamReady(const wstring& strDSURL, const wstring& strDSToken);

	public:
		pf_jmsdk_IJMCommonEventCallback_OnSignOn mpfOnSignOn;
		pf_jmsdk_IJMCommonEventCallback_OnSignOff mpfOnSignOff;
		pf_jmsdk_IJMCommonEventCallback_OnPreseceChange mpfOnPreseceChange;
		pf_jmsdk_IJMCommonEventCallback_OnUserSignOff mpfOnUserSignOff;
		pf_jmsdk_IJMCommonEventCallback_OnDSParamReady mpfOnDSParamReady;
	};

	class JMMeetingMgrImpl : public JMMeetingMgr
	{
	public:
		JMMeetingMgrImpl();
		~JMMeetingMgrImpl();

		void FuncInit(JMHandle libHandle);
		void FuncUnInit();

	public:
		virtual mstdapi Initialize(ConOIServieType const &conType);

		virtual mstdapi ReleaseResources();

		virtual mstdapi NetworkChanged(BOOL bConnected);

		virtual mstdapi GetOnlineSwitch(OUT BOOL * pVal);

		virtual mstdapi GetOfflineSwitch(OUT BOOL * pVal);

		virtual mstdapi ListEvents(IN const SYSTEMTIME& stSelectedDay);

		virtual mstdapi RefreshCalendar();

		virtual mstdapi TodayChanged(IN BOOL bForceRefresh);

		virtual mstdapi GetWbxMeetingDetail(IN wstring const& strEventID);

		virtual mstdapi GetCMRInfo(IN wstring const& strMeetingKeyList);

		virtual mstdapi ViewEvent(IN wstring const& strEventID);

		virtual mstdapi GetCurrentMailType(OUT ConOIServieType& conType);

		virtual mstdapi LaunchWebexMeeting(IN wstring const& strEventID); 

		virtual mstdapi SendMail(IN const wstring& strSubject, IN const wstring& strTos, IN const wstring& strBody, IN const wstring& strMeetingKey);

	public:
		pf_jmsdk_JMMeetingMgr_Initialize mpfInitialize;
		pf_jmsdk_JMMeetingMgr_ReleaseResources mpfReleaseResources;
		pf_jmsdk_JMMeetingMgr_NetworkChanged mpfNetworkChanged;
		pf_jmsdk_JMMeetingMgr_GetOnlineSwitch mpfGetOnlineSwitch;
		pf_jmsdk_JMMeetingMgr_GetOfflineSwitch mpfGetOfflineSwitch;
		pf_jmsdk_JMMeetingMgr_ListEvents mpfListEvents;
		pf_jmsdk_JMMeetingMgr_RefreshCalendar mpfRefreshCalendar;
		pf_jmsdk_JMMeetingMgr_TodayChanged mpfTodayChanged;
		pf_jmsdk_JMMeetingMgr_GetWbxMeetingDetail mpfGetWbxMeetingDetail;
		pf_jmsdk_JMMeetingMgr_GetCMRInfo mpfGetCMRInfo;
		pf_jmsdk_JMMeetingMgr_ViewEvent mpfViewEvent;
		pf_jmsdk_JMMeetingMgr_GetCurrentMailType mpfGetCurrentMailType;
		pf_jmsdk_JMMeetingMgr_LaunchWebexMeeting mpfLaunchWebexMeeting;
		pf_jmsdk_JMMeetingMgr_SendMail mpfSendMail;
	};

class IWbxMeetingAccountMgrImpl : public IWbxMeetingAccountMgr
{
public:
	IWbxMeetingAccountMgrImpl();
	~IWbxMeetingAccountMgrImpl();

	void FuncInit(JMHandle libHandle);
	void FuncUnInit();

public:
	/**
	*@brief This function used to install observer.
	*@param pOB the pointer to IWbxMeetingAccountObserve.
	*@return  no return.
	*/
	virtual void RegisterObserver(IWbxMeetingAccountObserve *pOB);

	/**
	*@brief This function used to uninstall observer.
	*@param pOB the pointer to IWbxMeetingAccountObserve.
	*@return  no return.
	*/
	virtual void UnregisterObserver(IWbxMeetingAccountObserve *pOB);

	/**
	*@brief This function used to judge whether have a active account exist.
	*@return  1 is have and other is none.
	*/
	virtual bool IsActiveAccountExist();

	/**
	*@brief This function used to verify account, it will fire a callback function OnVerifyAccount.
	*@param strSiteUrl  Verify account site URL;
	*@param strUserName Verify account user name;
	*@param strCred     Verify account credentials;
	*@param strCred     whether SSO site;
	*@return  no return.
	*/
	virtual void VerifyAccount(const wstring& strSiteUrl, const wstring& strUserName, const wstring& strCred, bool bSSO);

	/**
	*@brief This function used to initialization meeting account.
	*@return  no return.
	*/
	virtual void SetAccountEmpty();

	/**
	*@brief This function used to set a default account.
	*@param account  A reference to a TWBXMeetingAccountInfo object;
	*@param siteInfo A reference to a TWBXUserSiteInfo object;
	*@return  no return.
	*/
	virtual void SetActiveAccount(TWBXMeetingAccountInfo& account);

	/**
	*@brief This function used to tell SDK that verify default account failed.
	*@param eErrCode  The last error of verify account.
	*@return  no return.
	*/
	virtual void NoticeInvalidCertInMeetingSite(JMErrorCodeDef::EJMMeetingAccountErrorCode eErrCode);

	/**
	*@brief This function used to get default account.
	*@param account  A reference to a TWBXMeetingAccountInfo object, use to receive default account info.
	*@return  no return.
	*/
	virtual void GetMeetingAccount(TWBXMeetingAccountInfo& account);

	/**
	*@brief This function used to refresh session ticket.
	*@param wstring A reference to sessionticket.
	*@return  no return.
	*/
	virtual void RefreshSessionTicket(const wstring& strSessionTicket);

	virtual void CheckSSOSiteList(const wstring& strSiteList);

	virtual void CheckSiteSSOFlag(const wstring& strSiteUrl);

	virtual E_WBX_SITE_SSO_FLAG GetSiteSSOFlag(const wstring& strSiteUrl);

public:
	pf_jmsdk_IWbxMeetingAccountMgr_RegisterObserver mpfRegisterObserver;
	pf_jmsdk_IWbxMeetingAccountMgr_UnregisterObserver mpfUnregisterObserver;
	pf_jmsdk_IWbxMeetingAccountMgr_IsActiveAccountExist mpfIsActiveAccountExist;
	pf_jmsdk_IWbxMeetingAccountMgr_VerifyAccount mpfVerifyAccount;
	pf_jmsdk_IWbxMeetingAccountMgr_SetAccountEmpty mpfSetAccountEmpty;
	pf_jmsdk_IWbxMeetingAccountMgr_SetActiveAccount mpfSetActiveAccount;
	pf_jmsdk_IWbxMeetingAccountMgr_NoticeInvalidCertInMeetingSite mpfNoticeInvalidCertInMeetingSite;
	pf_jmsdk_IWbxMeetingAccountMgr_GetMeetingAccount mpfGetMeetingAccount;
	pf_jmsdk_IWbxMeetingAccountMgr_RefreshSessionTicket mpfRefreshSessionTicket;
	pf_jmsdk_IWbxMeetingAccountMgr_CheckSSOSiteList mpfCheckSSOSiteList;
	pf_jmsdk_IWbxMeetingAccountMgr_CheckSiteSSOFlag mpfCheckSiteSSOFlag;
	pf_jmsdk_IWbxMeetingAccountMgr_GetSiteSSOFlag mpfGetSiteSSOFlag;
};

	class IMeetingAccountInfoCallbackImpl : public IMeetingAccountInfoCallback
	{
	public:
		IMeetingAccountInfoCallbackImpl();
		~IMeetingAccountInfoCallbackImpl();

		void FuncInit(JMHandle libHandle);
		void FuncUnInit();

	public:
		virtual void OnWapiGetAllAccount(BOOL bSuccess, vector<TWBXMeetingAccountInfo> &accounts);

		virtual void OnWapiGetDefaultAccount(BOOL bSuccess, TWBXMeetingAccountInfo &account, wstring& strSKCreateTime, wstring& strSKTime2Live, wstring strReason, int nExceptionID);

		virtual void OnWapiDelAccount(BOOL bSuccess, INT nExceptionID, wstring& strReason);

		virtual void OnWapiSetAccount(BOOL bSuccess, TWBXMeetingAccountInfo &account, wstring& strSKCreateTime, wstring& strSKTime2Live, wstring strReason, int nExceptionID);

	public:
		pf_jmsdk_IMeetingAccountInfoCallback_OnWapiGetAllAccount mpfOnWapiGetAllAccount;
		pf_jmsdk_IMeetingAccountInfoCallback_OnWapiGetDefaultAccount mpfOnWapiGetDefaultAccount;
		pf_jmsdk_IMeetingAccountInfoCallback_OnWapiDelAccount mpfOnWapiDelAccount;
		pf_jmsdk_IMeetingAccountInfoCallback_OnWapiSetAccount mpfOnWapiSetAccount;
	};

class IInstantMeetingMgrImpl : public IInstantMeetingMgr
{
public:
	IInstantMeetingMgrImpl();
	~IInstantMeetingMgrImpl();

	void FuncInit(JMHandle libHandle);
	void FuncUnInit();

public:
	virtual void RegisterEvent(IInstantMeetingEvent * pEvent);

	virtual void UnregisterEvent(IInstantMeetingEvent * pEvent);

	virtual void OpenOneClickSetting();

	virtual int GetLastError(wstring& strErrMsg);	//return value is ref EJMInstantMeetingErrorCode

	virtual BOOL IsInMeeting();

	virtual BOOL CanStartMeeting();

	virtual BOOL CanJoinMeeting(const wstring& strSessionKey);

	virtual BOOL StartInstantMeeting(wstring const& strMeetingName, vector<InviteeInfo> const& vecUserList, wstring const&  strDefSessionID);

	virtual BOOL Accept(const wstring& strSessionName);

	virtual BOOL Decline(const wstring& strSessionName);

	virtual BOOL Reinvite(const wstring& strSessionName);

	virtual BOOL OpenMeetingDetailPage(const TCHAR* pszJoinUrl);

	virtual BOOL StartJoinMeetingByUrl(const TCHAR* pszJoinUrl);

	virtual BOOL StartScheduledMeeting(wstring const& strMeetingKey);

	virtual BOOL LaunchMeetingByJoinURL(wstring const& strJoinURL, BOOL bHost, wstring const& strEventID);

	virtual BOOL JoinMeetingByMK(wstring const& strMeetingKey, wstring const& strMeetingPass);

	virtual BOOL IsMeetingInProgress(IN const wstring& strMeetingKey);

	virtual BOOL GetJoinURL(const TCHAR* pszSite, const TCHAR* pszEventID, const TCHAR* pszMeetingKey, const TCHAR* pszMeetingPwd, bool bSetMK, const TCHAR* pszEmail, const TCHAR* pszUserName, TCHAR* pszURL, unsigned long* pulURLLen, int eSenario);

	virtual void GetInstantMeetingInfoByMK(const wstring& strMeetingKey, DWORD& dwSiteType, wstring& strInviteByEmail, wstring& strQSInviteURL, wstring& strInviteCode, wstring& strOfflineBuddies, BOOL& bFromClient, BOOL& bHost);

	virtual BOOL StartCMRMeeting(BOOL isLaunchMeeting);

	virtual BOOL JoinCMRMeeting(wstring const& strSiteURL, wstring const& strMeetingKey, wstring const& strMTGTK);

public:
	pf_jmsdk_IInstantMeetingMgr_RegisterEvent mpfRegisterEvent;
	pf_jmsdk_IInstantMeetingMgr_UnregisterEvent mpfUnregisterEvent;
	pf_jmsdk_IInstantMeetingMgr_OpenOneClickSetting mpfOpenOneClickSetting;
	pf_jmsdk_IInstantMeetingMgr_GetLastError mpfGetLastError;
	pf_jmsdk_IInstantMeetingMgr_IsInMeeting mpfIsInMeeting;
	pf_jmsdk_IInstantMeetingMgr_CanStartMeeting mpfCanStartMeeting;
	pf_jmsdk_IInstantMeetingMgr_CanJoinMeeting mpfCanJoinMeeting;
	pf_jmsdk_IInstantMeetingMgr_StartInstantMeeting mpfStartInstantMeeting;
	pf_jmsdk_IInstantMeetingMgr_Accept mpfAccept;
	pf_jmsdk_IInstantMeetingMgr_Decline mpfDecline;
	pf_jmsdk_IInstantMeetingMgr_Reinvite mpfReinvite;
	pf_jmsdk_IInstantMeetingMgr_OpenMeetingDetailPage mpfOpenMeetingDetailPage;
	pf_jmsdk_IInstantMeetingMgr_StartJoinMeetingByUrl mpfStartJoinMeetingByUrl;
	pf_jmsdk_IInstantMeetingMgr_StartScheduledMeeting mpfStartScheduledMeeting;
	pf_jmsdk_IInstantMeetingMgr_LaunchMeetingByJoinURL mpfLaunchMeetingByJoinURL;
	pf_jmsdk_IInstantMeetingMgr_JoinMeetingByMK mpfJoinMeetingByMK;
	pf_jmsdk_IInstantMeetingMgr_IsMeetingInProgress mpfIsMeetingInProgress;
	pf_jmsdk_IInstantMeetingMgr_GetJoinURL mpfGetJoinURL;
	pf_jmsdk_IInstantMeetingMgr_GetInstantMeetingInfoByMK mpfGetInstantMeetingInfoByMK;
	pf_jmsdk_IInstantMeetingMgr_StartCMRMeeting mpfStartCMRMeeting;
	pf_jmsdk_IInstantMeetingMgr_JoinCMRMeeting mpfJoinCMRMeeting;
};

class IDSMgrImpl : public IDSMgr
{
public:
	IDSMgrImpl();
	~IDSMgrImpl();

	void FuncInit(JMHandle libHandle);
	void FuncUnInit();

public:
	virtual BOOL CancelStartSharing();

	virtual BOOL CanStartSharing(const wstring& strSessionName);

	virtual BOOL IsInsharing();

	virtual BOOL Start(const wstring& strSessionName);

	virtual BOOL Join(const wstring& strSessionName);

	virtual BOOL Decline(const wstring& strSessionName);

	virtual BOOL StopCurSession();

	virtual BOOL ReInviteCurSession();

	virtual BOOL ReSharing();

	virtual BOOL ChangePresenter();

	virtual BOOL IsPresenter();

	virtual BOOL CanJoinSharing(const wstring& strSessionName, INT& eType);

public:
	pf_jmsdk_IDSMgr_CancelStartSharing mpfCancelStartSharing;
	pf_jmsdk_IDSMgr_CanStartSharing mpfCanStartSharing;
	pf_jmsdk_IDSMgr_IsInsharing mpfIsInsharing;
	pf_jmsdk_IDSMgr_Start mpfStart;
	pf_jmsdk_IDSMgr_Join mpfJoin;
	pf_jmsdk_IDSMgr_Decline mpfDecline;
	pf_jmsdk_IDSMgr_StopCurSession mpfStopCurSession;
	pf_jmsdk_IDSMgr_ReInviteCurSession mpfReInviteCurSession;
	pf_jmsdk_IDSMgr_ReSharing mpfReSharing;
	pf_jmsdk_IDSMgr_ChangePresenter mpfChangePresenter;
	pf_jmsdk_IDSMgr_IsPresenter mpfIsPresenter;
	pf_jmsdk_IDSMgr_CanJoinSharing mpfCanJoinSharing;
};

	class IJMIMDelegeteWrapper
	{
	public:
		void SetHandler(IJMIMDelegete* pIJMIMDelegete);
		void FuncInit(JMHandle libHandle);
	public:
		static BOOL SendCmd_DSInvitation(const wstring& strBuddyName, const wstring& strCmd, const wstring& strHtmlMessage, const wstring& strPlainMessage);

		static BOOL SendCmd_DSDecline(wstring& strSessionName, wstring& strCmdMsg);

		static BOOL SendCmd_DSCancelled(wstring& strSessionName, wstring& strCmdMsg);

		static BOOL SendCmd_MeetingInvitation(const wstring& strBuddyName, const wstring& strCmd, const wstring& strHtmlMessage, const wstring& strPlainMessage);

		static BOOL SendCmd_MeetingDecline(wstring& strSessionName, wstring& strCmdMsg);

		static BOOL SendCmd_MeetingCancelled(wstring& strSessionName, wstring& strCmdMsg);

		// Meeting IMAlert
		static BOOL SendCmd_IMAlert(const wstring& strBuddyName, const wstring& strCmd, const wstring& strHtmlMessage, const wstring& strPlainMessage);

	private:
		static IJMIMDelegete* m_pIJMIMDelegete;
	};

	class ICommonDependenciesDelegateWrapper
	{
	public:
		void SetHandler(ICommonDependenciesDelegate* pICommonDependenciesDelegate);
		void FuncInit(JMHandle libHandle);
	public:
		static wstring GetMyAccountName();

		static wstring GetMyAccountDisplayName();

		static wstring GetMyAccountEmail();

		static wstring GetBuddyDispName(const wstring& strURI);

		static wstring GetBuddyEmail(const wstring &strBuddyName);

		static wstring GetBuddyURIWithEmailaddress(const wstring& strEmailaddress);

		static BOOL IsAccount(const wstring& strSessionName);

		static BOOL IsSignedOn();

		static BOOL IsDSPolicyEnable(const wstring& strSessionName, int& nPolicyResult);

		static BOOL AutoRespPolicy(wstring const& strBuddyName, int nPolicyResult);

		static BOOL HasDSCapability(const wstring& strSessionName);

		static BOOL HasIMCapability(const wstring& strSessionName);

		static BOOL IsBuddyOnline(const wstring& strSessionName);

		static BOOL IsCupMode();

		static BOOL IsWbxMeetingEnabled();

		static wstring GetDSURL();

		static wstring GetDSToken();

		static wstring GetDSParam();

		static BOOL ProbeP2PDnd(wstring const& strBuddyName);

		static BOOL AutoRespDnd(wstring const& strBuddyName);

		static void AddInMeetingStatus();

		static void RemoveInMeetingStatus();

		static void AddInWebExMeetingStatus();

		static void RemoveInWebExMeetingStatus();

		static void AddSharingInWebExMeetingStatus();

		static void RemoveSharingInWebExMeetingStatus();

		static void AddInDSStatus();

		static void RemoveInDSStatus();

		static void AddSharingInDSStatus();

		static void RemoveSharingInDSStatus();

		//Minutes, enable automatic refresh for Lotus and Google calendar integration
		static unsigned int GetCalendarAutoRefreshTime();

	private:
		static ICommonDependenciesDelegate* m_pICommonDependenciesDelegate;
	};

	class JMLoggerWrapper
	{
	public:
		void SetHandler(JMLogger* pJMLogger);
		void FuncInit(JMHandle libHandle);
	public:
		static void log(int level, const char *sourceFile, int sourceLine, const char* function, const char* fmt, va_list args);

	private:
		static JMLogger* m_pJMLogger;
	};

	class JMMeetingMgrHandlerWrapper
	{
	public:
		void SetHandler(JMMeetingMgrHandler* pJMMeetingMgrHandler);
		void FuncInit(JMHandle libHandle);
	public:
		static void OnListOneDayEvents(wstring const& strEvents);

		static void OnMeetingStart(wstring const& strEventID, wstring const& strMeetingKey);

		static void OnMeetingEnd(wstring const& strEventID, wstring const& strMeetingKey);

		static void OnOvernight(MeetingMgrErrorCode eRet);

		static void OnGetWbxMeetingDetail(wstring const& strEventXML, wstring const& strMeetingDetail);

		static void OnInitializeOIFailed();

		static void OnInitializeResult(LONG const &lResult);

		static void OnMeetingReminderHappened(MeetingReminderItem const& objMeetingReminderItem);

		static void OnMeetingReminderEnded(wstring const & strEventID);

		static void OnMeetingIMAlertHappened(MeetingIMAlertItem const &obj);

		static void OnGetCMRInfo(const wstring& cmrInfo);

	private:
		static JMMeetingMgrHandler* m_pJMMeetingMgrHandler;
	};

class IWbxMeetingAccountObserveWrapper
{
public:
	void SetHandler(IWbxMeetingAccountObserve* pIWbxMeetingAccountObserve);
	void FuncInit(JMHandle libHandle);
public:
	/**
	*@brief If you want to verify a meeting account, that you can get this callback function to know success or fail.
	*@param bSuccess   1 is successful;
	*@param pAccount   get a pointer to TWBXMeetingAccountInfo date structure;
	*@param pSiteInfo  get a pointer to TWBXUserSiteInfo date structure;
	*@param eErrCode   If unsuccessful, will get a error code;
	*@return  no return.
	*/
	static void OnVerifyAccount(bool bSuccess, TWBXMeetingAccountInfo * pAccount, JMErrorCodeDef::EJMMeetingAccountErrorCode eErrCode);

	/**
	*@brief This callback function to notice active account change.
	*@param bExistActiveAccount  1 the active account changed.
	*@return  no return.
	*/
	static void OnNoticeActiveAccountChange(bool bExistActiveAccount);

	/**
	*@brief This callback function to notice session ticket refresh.
	*@param strSessionTicket  A reference to new session ticket.
	*@return  no return.
	*/
	static void OnNoticeSessionTicketRefreshed(const wstring& strSessionTicket);

	/**
	*@brief This callback function to notice verify default account failed.
	*@param eErrCode  Last error code of verify default account.
	*@return  no return.
	*/
	static void OnNoticeInvalidCertInMeetingSite(JMErrorCodeDef::EJMMeetingAccountErrorCode eErrCode);

	static void OnCheckSSOSiteListReady();

	static void OnCheckSiteSSOFlagReady(const wstring& strSiteUrl, E_WBX_SITE_SSO_FLAG flag);

private:
	static IWbxMeetingAccountObserve* m_pIWbxMeetingAccountObserve;
};

	class IMeetingAccountInfoDelegateWrapper
	{
	public:
		void SetHandler(IMeetingAccountInfoDelegate* pIMeetingAccountInfoDelegate);
		void FuncInit(JMHandle libHandle);
	public:
		static HRESULT __stdcall GetWbxAccountsAssocAsync();

		static HRESULT __stdcall GetDefWbxAccountAsync();

		static HRESULT __stdcall SetDefWbxAccountAsync(wstring const& strSite, wstring const& strUser, wstring const& strPwd, BOOL isSSO = FALSE);

		static HRESULT __stdcall DelWbxAccountAssocAsync(wstring const& strSite);

	private:
		static IMeetingAccountInfoDelegate* m_pIMeetingAccountInfoDelegate;
	};

class IInstantMeetingEventWrapper
{
public:
	void SetHandler(IInstantMeetingEvent* pIInstantMeetingEvent);
	void FuncInit(JMHandle libHandle);
public:
	static void OnMeetingStart(wstring const& strMeetingKey, wstring const& strSessionName, BOOL bHost);

	static void OnMeetingError(wstring const& strMeetingKey, wstring const& strSessionName, BOOL bHost);

	static void OnMeetingEnd(wstring const& strMeetingKey, wstring const& strSessionName, BOOL vbHost);

	static void OnMeetingInvitation(wstring const& strSessionName);

	static void OnMeetingCancelInvitation(wstring const& strSessionName);

	static void OnMeetingDecline(wstring const& strSessionName, wstring const& strBuddyName);

	static void OnPopupWaitDialog();

	static void OnCloseWaitDialog();

	static void OnShowErrorDialog(int nErrorCode);

	static void OnGetShortJoinURL(wstring const& pszSiteURL, wstring const& strEventID, wstring const& pszMeetingKey, wstring const& pszShortJoinURL, int eSenario);

	static void OnCMRMeetingStarted(const CMR_MeetingData & info);

	static void OnCMRMeetingJoined(const CMR_MeetingData & info);

	static void OnCMRMeetingFailed(int nErrorCode);

	static void OnCMRMeetingEnded();

private:
	static IInstantMeetingEvent* m_pIInstantMeetingEvent;
};

class IDSMgrEventWrapper
{
public:
	void SetHandler(IDSMgrEvent* pIDSMgrEvent);
	void FuncInit(JMHandle libHandle);
public:
	static void OnStartingDialogShow(bool bShow);

	static void OnNotifyUIUpdate();

	static void OnSessionStarted(const wstring& strSessionName);

	static void OnSessionEnded();

	static void OnSessionFailed(INT eType);

	static void OnSessionStopped();

	static void OnRecvSessionInvitation(const wstring& strSessionName);

	static void OnDeclineInvitation(const wstring& strSessionName);

	static void OnRequestOpenChat();

	static void OnRequestMinimizeChat();

	static void OnUserJoined();

	static void OnUserTryLeave(BOOL bHost);

	static void OnUserLeft();

	static void OnCleanSession(const wstring strSessionName);

	static void OnCleanUp();

	static void OnErrorMsg(const wstring& strSessionName, INT eType);

	static void OnPresenterDidChange();

private:
	static IDSMgrEvent* m_pIDSMgrEvent;
};

	class JMProxyWrapper
	{
	public:
		void SetHandler(JMProxy* pJMProxy);
		void FuncInit(JMHandle libHandle);
	public:
		static bool getProxy(const char *url, string &strServer, unsigned short &port, unsigned int &proxyType, unsigned int &proxyAuth, string &strUsername, string &strPassword, string &strBypass);

	private:
		static JMProxy* m_pJMProxy;
	};

	class INetworkTransportWrapper
	{
	public:
		void SetHandler(INetworkTransport* pINetworkTransport);
		void FuncInit(JMHandle libHandle);
	public:
		static void HttpRequest(const std::string& httpUrl, const std::vector<std::string>& httpHeader, const std::string& httpPostData, JMHttpMethod httpMethod, NetUtilSuccessProcT successProc, NetUtilErrorProcT errorProc);

		static void HttpRequestAsync(const std::string& httpUrl, const std::vector<std::string>& httpHeader, const std::string& httpPostData, JMHttpMethod httpMethod, NetUtilSuccessProcT successProc, NetUtilErrorProcT errorProc);

		static bool Registered();

	private:
		static INetworkTransport* m_pINetworkTransport;
	}; 

